import tkinter

from moving_out.case import carry_together_case
from matrx import cases
from tkinter import *
import webbrowser
from PIL import ImageTk, Image

if __name__ == "__main__":
    # start tkinter window to choose the scenario
    root = Tk()
    root.title('Choose scenario')
    # make it appear fullscreen
    root.attributes("-fullscreen", True)
    # change background colour
    root.config(bg='#00A6D6')

    # the choice to make
    choice = IntVar()

    # starting text
    text = Text(height=8, width=100, font=("Arial", 30), bg="#00A6D6", fg="#FFFFFF", highlightthickness=0, borderwidth=0)
    # center text
    text.tag_configure("center", justify="center")
    text.insert("1.0", "Welcome! \n \n Please pick one of these three scenario's:")
    text.tag_add("center", "1.0", "end")
    text.pack(pady=20)

    # three scenario's: the tutorial, the good agent, and the faulty agent
    # close window when button is pressed
    tutorial = Button(root, text="Tutorial", command=lambda: [choice.set(0), root.destroy()], font=("Arial", 30))
    tutorial.pack(pady=20)

    non_faulty = Button(root, text="Scenario A", command=lambda: [choice.set(1), root.destroy()], font=("Arial", 30))
    non_faulty.pack(pady=20)

    faulty = Button(root, text="Scenario B", command=lambda: [choice.set(2), root.destroy()], font=("Arial", 30))
    faulty.pack(pady=20)

    # infinite loop
    root.mainloop()

    # open localhost
    url = "http://127.0.0.1:3000/human-agent/human"
    webbrowser.get().open(url)

    # get chosen scenario
    scenario = choice.get()

    # run MATRX with the chosen scenario
    carry_together_case.run(scenario)